Global_TOPCWindow_IsCreated = false

local WTYPE_EDIT 		= 1
local WTYPE_COMBOBOX	= 4

local ID_BUTTON_OK	 	= 101

local ID_EDIT			= 1001
local ID_SLIDER			= 1003
local ID_COMBOBOX		= 1004

--   -    , 
--   -    .

function math_round( roundIn , roundDig )  
     local mul = math.pow( 10, roundDig )
     return math.floor( ( roundIn * mul ) + 0.5 ) / mul
end

-------------------------------------------------------------------------------------------------------------------

class 'TOPC_Window'
	function TOPC_Window:__init(wx_point,wx_size, sz_caption)
		
		self.frame = base.shell.gui.CreateWindow(sz_caption,wx_point, wx_size,
			base.stdlib.bit.bor( base.shell.gui.WS_CAPTION, base.shell.gui.WS_BORDER, base.shell.gui.WS_SYSMENU))

		self.frame:Connect(wx.wxEVT_DESTROY,  
			function(event)			
				self.OnCloseWindow(self)
			end)
		
		self.panel = nil
		self.button = nil
		self.text1 = nil
		self.text2 = nil
		
		self.OnPreInitWindow	= nil
	    self.OnInitWindow 	= nil
	    self.OnCloseWindow 	= nil
      	self.OnButton 		= nil
	end
	
	function TOPC_Window:Create()

		self.panel = wx.wxPanel(self.frame, 
			wx.wxID_ANY,wx.wxDefaultPosition,self.frame:GetSize())
		
		self.button = wx.wxButton(self.panel, ID_BUTTON_OK, "",
                          wx.wxPoint(85,80), wx.wxDefaultSize)
						  
		self.panel:Connect(ID_BUTTON_OK,wx.wxEVT_COMMAND_BUTTON_CLICKED,
						function(event)							
							self:OnButton(ID_BUTTON_OK)
						end)

		self.button:Connect(wx.wxID_ANY, wx.wxEVT_KEY_DOWN,
						function(event)
							self:OnKeyDown(event)
						end)

		if self.OnPreInitWindow ~= nil then
			self:OnPreInitWindow(self.panel)
		end

		if self.OnInitWindow ~= nil then
			self:OnInitWindow(self.panel)
		end

		self.frame:Show(true)
	end
	
	function TOPC_Window:Close()
		self.frame:Close()
	end
	
	function TOPC_Window:OnKeyDown(event)
		
		local keyCode = event:GetKeyCode()
		
		if event:AltDown() and keyCode==243 then
			self:Close()
		end
							
		if keyCode == 27 then
			self:Close()
		end
		
		if keyCode == 32 or keyCode == 13 or keyCode == 370 then			
			self:OnButton(ID_BUTTON_OK)
		end
		
	end

-------------------------------------------------------------------------------------------------------------------

class 'TOPC_EditWindow' (TOPC_Window)
--{
	function TOPC_EditWindow:__init(wx_point, wx_size, baseprim)
	  TOPC_Window.__init(self, wx_point, wx_size, baseprim.alertname)	
	  
	  wx_point.x = wx_point.x - wx_size:GetWidth()/2
	  wx_point.y = wx_point.y - wx_size:GetHeight()/2 - 10		
		
	  self.current_value 	= nil
	  self.new_value 		= nil
	  self.baseprim 	    = baseprim

	  self.edit = nil		
	end
	
	function TOPC_EditWindow:OnInitWindow(panel)
		
		self.text1 = wx.wxStaticText(panel, wx.wxID_ANY, ": ",
			wx.wxPoint(15,15), wx.wxSize(50, -1))
			
		self.text3 = wx.wxStaticText(panel, wx.wxID_ANY, self.current_value, 
			wx.wxPoint(85,15), wx.wxSize(150, -1))
			
		
		self.text2 = wx.wxStaticText(panel, wx.wxID_ANY, ": ",
			wx.wxPoint(15,40), wx.wxSize(50, -1))
		
		self.edit2 = wx.wxTextCtrl(self.panel, ID_EDIT, 
			self.current_value,	wx.wxPoint(85, 40), wx.wxSize(150, -1))
						
		self.button:Move(100,85)

	end
	
	function TOPC_EditWindow:SetCurrentValue(current_value)
		self.current_value = current_value
		self.new_value = current_value
	end
	
	function TOPC_EditWindow:OnButton(id)	
		if id == ID_BUTTON_OK then		
			self.new_value = self.edit2:GetLineText(0)
			self.baseprim:OnWriteValue(self.new_value)
		end
	end
	
	function TOPC_EditWindow:OnCloseWindow()
				
	end
--}

-------------------------------------------------------------------------------------------------------------------

class 'TOPC_ComboBoxWindow' (TOPC_Window)
--{
	function TOPC_ComboBoxWindow:__init(wx_point,wx_size, baseprim)
		TOPC_Window.__init(self, wx_point, wx_size, baseprim.alertname)
		
		wx_point.x = wx_point.x - wx_size:GetWidth()/2
		wx_point.y = wx_point.y - wx_size:GetHeight()/2 - 10		
		
		self.current_value 	= nil
		self.new_value 		= nil
		self.baseprim 		= baseprim
		
		self.combobox = nil		
		
		self.text1 = nil
		self.text2 = nil
		self.text3 = nil

		
	end
	
	function TOPC_ComboBoxWindow:OnInitWindow(panel)
	 
	   	self.text1 = wx.wxStaticText(panel, wx.wxID_ANY, ": ",
			wx.wxPoint(15,15), wx.wxSize(100, -1))
			
		self.text3 = wx.wxStaticText(panel, wx.wxID_ANY,self.current_value, 
			wx.wxPoint(85,15), wx.wxSize(100, -1)) 

		self.text2 = wx.wxStaticText(panel, wx.wxID_ANY, ":",
			wx.wxPoint(15,35), wx.wxSize(40, -1))	
			
	
		self.combobox = wx.wxComboBox(panel, ID_COMBOBOX, "wxComboBox",
		 wx.wxPoint(80,35), wx.wxSize(150, -1),{},
		wx.wxCB_READONLY)			
	end
	
	function TOPC_ComboBoxWindow:SetCurrentValue(current_value)
		self.current_value = current_value
	end
	
	function TOPC_ComboBoxWindow:MyAdd (str_value)
	    self.combobox:Append (str_value[0])
	    self.combobox:Append (str_value)
	end
	
	function TOPC_ComboBoxWindow:OnButton(id)	
	if id == ID_BUTTON_OK 
	 then
	     -- c 0  
		 local value = self.combobox:GetSelection()
		 self.baseprim:OnWriteValue(value)
	 end		
	end
	
	function TOPC_ComboBoxWindow:OnCloseWindow()
		
	end
	
--}

-------------------------------------------------------------------------------------------------------------------

class 'topc_string_baseprim' --       
--{
	function topc_string_baseprim:__init(primname)
	    -- 
    	-- self    
	    self.primname = primname
		self.alertname = nil
		self.topc_item = nil
		self.topc_itemdata = nil
		self.wnd_type = nil
		self.l_bound = nil
		self.r_bound = nil
		self.window = nil
		--   
		self.wndSelector = {
			[WTYPE_EDIT]    	= TOPC_EditWindow,
			[WTYPE_COMBOBOX]  	= TOPC_ComboBoxWindow}
		--  	
		self.wndSizes ={
			[WTYPE_EDIT] 		= wx.wxSize(300,150),
			[WTYPE_COMBOBOX] 	= wx.wxSize(250,150)}
		--    
		self.OnLocalItemDataChanged = nil
	    self.OnLButtonDblClick = nil
	    self.OnLocalWriteValue = nil	
	end
	-- Event:       Scada	
	function topc_string_baseprim:clickLButtonDblClick(point, topc_item, topc_itemdata) 

		if Global_TOPCWindow_IsCreated then
			return
		end
	   --     OPC- 	
       --if  (topc_item == nil) or (topc_itemdata == nil) or (topc_itemdata.Quality ~= opc.da.tekon.ItemData.QUALITY_GOOD)  then			
	   --	   return
	   --	end
		
		self.topc_item = topc_item
		self.topc_itemdata = topc_itemdata
		
        --  ""    
		local prop = self.topc_item:GetProperty(opc.da.tekon.Item.JOURNAL_ALERT)
		if prop ~= nil and prop.Data ~= nil then
			self.alertname = prop.Data.String
		end			
		--      
		if (self.OnLButtonDblClick ~= nil) then 
		   self.OnLButtonDblClick(self,point:wxPoint())
		end   
	end
	-- Event   Item- 
	function topc_string_baseprim:OnItemDataChanged(topc_item, topc_itemdata)       
       --    
       if topc_item == nil or topc_itemdata ==nil  or topc_itemdata.Data ==nil then
	      return ""
	   end	  
       if  topc_itemdata.Quality ~= opc.da.tekon.ItemData.QUALITY_GOOD  then
		return "---"
       end
	   --      
       if (self.OnLocalItemDataChanged  ~= nil) then 
	     return self.OnLocalItemDataChanged (self,topc_item,topc_itemdata)
	   end	 
	end
    
	function topc_string_baseprim:OnWriteValue(value)		
		if (self.OnLocalWriteValue ~= nil) then
           self.OnLocalWriteValue (self,value)
           return 		   
		end 
		--wx.wxMessageBox ('write value '..value,'write value')
		local vval = base.Variant(value)
		vval:ChangeType(base.Variant.VT_NUMBER)
		self.topc_item:AsyncWrite(vval)		
		self.window:Close()
		self.window = nil	
	end 
	
----------------------------------------------------------------------------------------

class 'topc_string_primitive' (topc_string_baseprim)
	function topc_string_primitive:__init(primname, wnd_type)		
		topc_string_baseprim.__init(self,primname)		
		self.wnd_type = wnd_type
	end
		
	function topc_string_primitive:OnLButtonDblClick(wx_point)
		
		if Global_TOPCWindow_IsCreated then
			return
		end
					        
		self.window = self.wndSelector[self.wnd_type](wx_point, self.wndSizes[self.wnd_type], self)		
		self.window:SetCurrentValue(self.topc_itemdata.Data.String)
					
		self.window:Create()
	end	
	
	function topc_string_primitive:OnLocalItemDataChanged(topc_item, topc_itemdata) 
          return  ''..math_round (topc_itemdata.Data.Number,2) 	         
    end 
	
	--function topc_string_primitive:OnLocalWriteValue (value)
	--  wx.wxMessageBox ('write local value ','write val')
	--end
	

-------------------------------------------------------------------------------------------------------------------

class 'topc_combo' (topc_string_baseprim)
--{
	function topc_combo:__init(primname, wnd_type)				
		topc_string_baseprim.__init(self, primname)		
		self.wnd_type = wnd_type
	end
	

	function topc_combo:OnLButtonDblClick(wx_point)
		if Global_TOPCWindow_IsCreated then
			return
		end       
		self.window = self.wndSelector[self.wnd_type](wx_point, self.wndSizes[self.wnd_type], self)	
		self.window:SetCurrentValue(self.data[self.topc_itemdata.Data.Integer])
	    self.window:Create()
		self.window:MyAdd (self.data)	
	end	
	

	function topc_combo:Elements (combovalues)
	 self.data = combovalues 
	end
	
	function topc_combo:OnLocalItemDataChanged(topc_item, topc_itemdata) 
	 return self.data [topc_itemdata.Data.Integer]	  
    end
	

-------------------------------------------------------------------------------------------------------------------
--  .....
-------------------------------------------------------------------------------------------------------------------

topc_object0 = topc_string_primitive(" Edit", WTYPE_EDIT)

topc_object1 = topc_combo (" ComboBox", WTYPE_COMBOBOX)
combo1=
{
[0] = "",
[1] = ""
}
topc_object1:Elements (combo1)

topc_object2 = topc_combo (" ComboBox", WTYPE_COMBOBOX)
combo2=
{
 [0] = "",
 [1] = "",
 [2] = "",
 [3] = "",
 [4] = "",
 [5] = "",
 [6] = "",
 [7] = "",
 [8] = "",
 [9] = "",
 [10] = "  ",
 [11] = "  ",
 [12] = "  "
 }
topc_object2:Elements (combo2)



